/******************************************************************************
 *
 *		M M A 8 4 5 1 Q    A C C E L E R O M E T E R   H E A D E R
 *
 */
 #ifndef ACCEL_H
 #define ACCEL_H
 
 #include "i2c.h"
 #include "eeprom.h"
 #include "p18lf14k22.h"
 
 typedef unsigned char uchar;
 
// Hardware Pins
#define CAL_TRIS			TRISBbits.TRISB7
#define CAL_PIN				PORTBbits.RB7
#define CAL_PULLUP			WPUBbits.WPUB7
#define CAL_IOC				IOCBbits.IOCB7	
#define INT1_TRIS			TRISAbits.TRISA1
#define INT2_TRIS			TRISAbits.TRISA2		
 
// Accelerometer I2C address
#define ACC_ADDR			0x1c
 
// Accelerometer registers
#define HP_FILTER_CUTOFF                0x0f
#define CTRL_REG1			0x2a
#define CTRL_REG2			0x2b
#define CTRL_REG3			0x2c
#define CTRL_REG4			0x2d
#define CTRL_REG5			0x2e
#define XYZ_DATA_CFG                    0x0e
#define F_SETUP				0x09
#define OUTPUT_REGS			0x01
#define INT_SRC_REG			0x0c
#define PULSE_CFG			0x21
#define PULSE_SRC			0x22
#define PULSE_THS_X			0x23
#define PULSE_THS_Y			0x24
#define PULSE_THS_Z			0x25
#define PULSE_TMLT			0x26
#define PULSE_LTCY			0x27
#define PULSE_WIND			0x28
#define FF_MT_CFG			0x15
#define FF_MT_THS			0x17
#define FF_MT_COUNT			0x18
#define ASLP_COUNT			0x29
#define SYSMOD				0x0b
#define TRANS_CFG			0x1d
#define TRANS_THS			0x1f
#define TRANS_COUNT			0x20

// Acceleromenet events
#define NEW_DATA_EVT                    0x01
#define ACC_SLEEP_EVT			0x02
#define CAL_PRESS_EVT			0x04
#define CAL_RELEASE_EVT			0x08
 
void accInitialise(void);
void accStart(void);
void accSet(uchar reg, uchar value);
uchar accGet(uchar reg);
void accInt1isr(void);
void accInt2isr(void);
void accCalisr(void);
void accT0isr(void);
 #endif